
//M-7017 Modbus RTU Master

HANDLE h_RTU_Master;
int NetID = 1;
int addr = 0;
int ch_count = 8;
WORD AI_value[8]; //for example, we have a two-channel AO module

static char str_AI0[10];
static char str_AI1[10];
static char str_AI2[10];
static char str_AI3[10];
static char str_AI4[10];
static char str_AI5[10];
static char str_AI6[10];
static char str_AI7[10];


//SCADA Modbus TCP Slave

#define PORT_BIND 502
HANDLE h_TCP_Slave = 0;
char DioBuf[2];
unsigned long mts_status;
WORD      AioBuf[8]; // 16-bit x6 AIO buffers (can be more)

int i ;

// Settings
void Frame12OnCreate()
{
  h_RTU_Master = uart_Open("COM1,9600,N,8,1");      //M-7017

  h_TCP_Slave = hmi_TCPNew();// Listen and wait for accepting
  hmi_TCPListen(h_TCP_Slave, PORT_BIND);
  memset(DioBuf, 0, sizeof(DioBuf));    // Clear buffer
  memset(AioBuf, 0, sizeof(AioBuf));
  mts_RegisterSlave(1, 0, 0, DioBuf, 0, 8, AioBuf);
}


void Timer13OnExecute(tWidget *pWidget)  //M-7017
{

   mrm_ReadAI (h_RTU_Master, NetID, addr, ch_count, AI_value);     //M-7017   8AI

   usprintf(str_AI0,"%d",AI_value[0]);           //display
   LabelTextSet(&Label4,str_AI0);

   usprintf(str_AI1,"%d",AI_value[1]);
   LabelTextSet(&Label5,str_AI1);

   usprintf(str_AI2,"%d",AI_value[2]);
   LabelTextSet(&Label6,str_AI2);

   usprintf(str_AI3,"%d",AI_value[3]);
   LabelTextSet(&Label7,str_AI3);

   usprintf(str_AI4,"%d",AI_value[4]);
   LabelTextSet(&Label8,str_AI4);

   usprintf(str_AI5,"%d",AI_value[5]);
   LabelTextSet(&Label9,str_AI5);

   usprintf(str_AI6,"%d",AI_value[6]);
   LabelTextSet(&Label10,str_AI6);

   usprintf(str_AI7,"%d",AI_value[7]);
   LabelTextSet(&Label11,str_AI7);

}

void Timer12OnExecute(tWidget *pWidget)    //10 ms         //SCADA TCP Slave
{

  
  mts_status = mts_ProcessCmd(h_TCP_Slave);   //Process the Modbus TCP Slave command (suggested for every 10 ms).
  
  for(i=0 ; i<9 ; i++)
     {

      AioBuf[i] = AI_value[i];

     }

}





void Frame12OnDestroy()
{
  uart_Close(h_RTU_Master);
  hmi_TCPClose (h_TCP_Slave);
}





