#include "hmiworks.h"
BYTE ladder_main(BYTE);
static BYTE r_out(BYTE);

int _CurrentFrame = 0;
int _tpd_tcp_inited = 0;

char *g_FrameNames[] = 
{
  "Frame1",
};

const int g_FrameCount = (sizeof(g_FrameNames)/sizeof(char *));



void CheckModbus()
{
}

void _tpd_tcp_initial()
{
   if ( !lwIPLocalIPAddrGet() ) return;


   _tpd_tcp_inited = 1;
}

volatile unsigned long g_TimerTicksCount = 0;
void hmi_TimerTrigger()
{
  g_TimerTicksCount++;
  if (table_init_flag && (g_TimerTicksCount%(100/10)) == 0) AddQueueMessage(0);
  
  if ( _tpd_tcp_inited ) {
     if ((g_TimerTicksCount%50) == 0) CheckModbus();
  } else if ( g_TimerTicksCount > 80 )
     _tpd_tcp_initial();
  
  switch(_CurrentFrame) {
    case 1: {
     TimerUpdate(&Timer12, 10);
     TimerUpdate(&Timer13, 10);
    break;
    }
  }
}

void FreeCurrentFrame()
{
  switch (_CurrentFrame)
  {
	case 1: FreeWidget1(); break;
  }
}

void hmi_GotoFrame(int nFrame)
{
  WidgetMessageQueueProcessEx(WIDGET_MSG_PAINT);

  switch(nFrame)
  {
	case 1: _frame1(); break;
  }

  WidgetMessageQueueClear();
  WidgetPaint(WIDGET_ROOT);
}

int hmi_IndexOfFrame(const char *frame_name)
{
    int i;
    for (i=0; i<g_FrameCount; i++)
       if (strcmp(frame_name, g_FrameNames[i]) == 0) return i+1;
    return 0;
}


void hmi_GotoFrameByName(const char *frame_name)
{
    hmi_GotoFrame(hmi_IndexOfFrame(frame_name));
}

long default_timer_proc(tWidget *pWidget, unsigned long ulMessage,
                     unsigned long ulParam1, unsigned long ulParam2)

{
  ladder_main(1);
  passDataThruBindingOnChange();
  r_out(1);
  return 1;
}

static BYTE r_out(BYTE en)
{
  default_output(1);

  default_input(1);

  return 0;
}

void _frame0()
{
  tContext sContext;
  
  RegisterNullWidgetMsgProc(default_timer_proc);
  
  GrContextInit(&sContext, HMI_DISPLAY_DRIVER_PTR);
  hmi_GotoFrame(1);
  GrFlush(&sContext);
}
