#define HMI_STARTUP_DELAY 100
#define HMI_WDT_ENABLE 0
#define HMI_WDT_TIMEOUT 4000
#define HMI_WDT_CLEAR 1000
#define HMI_STARTUP_BEEP 1
#define HMI_TOUCH_BEEP 1
#define HMI_BEEP_FREQ 800
#define HMI_BEEP_MS 25
#define HMI_LCD_BRIGHTNESS 180
#define HMI_STARTUP_LED 0
#define HMI_LCD_AUTO_OFF 0
#define HMI_LCD_ON_BEEP 1
#define HMI_LCD_OFF_BEEP 1
#define HMI_TCP_TIMEOUT_BEEP 0


#include "hmiworks.h"
//#include "hmi_options.h"

#define TICKS_PER_SECOND 100
#define MS_PER_TICK      (1000 / TICKS_PER_SECOND)
//#define APPLICATION_TITLE "TouchPAD-ICPDAS"
//#define IPADDR(a,b,c,d)		(( ((unsigned int)a) << 24) | (b << 16) | (c << 8) | d)

#define USE_DHCP			         0
#define DEFAULT_IPADDR          	IPADDR(10,1,0,135)
#define DEFAULT_NET_MASK        	IPADDR(255,255,0,0)
#define DEFAULT_GATEWAY_ADDR    	IPADDR(10,1,0,254)

#define IPADDR_USE_STATIC       0
#define IPADDR_USE_DHCP         1
#define IPADDR_USE_AUTOIP       2

void SysTickIntHandler()
{
   hmi_TimerTrigger();
}

int main(void)
{
   unsigned long ulUser0, ulUser1;
   unsigned char pucMACAddr[6];

   if ( HMI_STARTUP_DELAY )
      hmi_DelayUS( HMI_STARTUP_DELAY * 1000 ); 

   HMI_INIT(O_LANDSCAPE);

   if ( HMI_WDT_ENABLE )  // Enable Watchdog
   {
      hmi_WdtAutoClear( HMI_WDT_CLEAR );
      hmi_WdtEnable( HMI_WDT_TIMEOUT );
   }

   hmi_Beep();

   FlashUserGet(&ulUser0, &ulUser1);
   pucMACAddr[0] = 0x00 & 0xff;
   pucMACAddr[1] = 0x0D & 0xff;
   pucMACAddr[2] = 0xE0 & 0xff;
   pucMACAddr[3] = ulUser1 & 0xff;
   pucMACAddr[4] = (ulUser1 >> 8) & 0xff;
   pucMACAddr[5] = (ulUser1 >> 16) & 0xff;

#if USE_DHCP == 1
   lwIPInit(pucMACAddr, 0, 0, 0, IPADDR_USE_DHCP);
#elif USE_DHCP == 0
   lwIPInit(pucMACAddr, DEFAULT_IPADDR, DEFAULT_NET_MASK, DEFAULT_GATEWAY_ADDR, IPADDR_USE_STATIC);
#elif USE_DHCP == 2
   do {
      unsigned long ulParams[4];
      hmi_NetworkParamsGet(ulParams, ulParams +1, ulParams +2, ulParams +3);
      if ( ulParams[0] == 1 ) // DHCP enabled
         lwIPInit(pucMACAddr, 0, 0, 0, IPADDR_USE_DHCP);
      else
         lwIPInit(pucMACAddr, ulParams[1], ulParams[2], ulParams[3], IPADDR_USE_STATIC);   
   } while (0);   
#endif
   LocatorMACAddrSet(pucMACAddr);
   
   
   hmi_TCPInit();
   hmi_TCPTimeoutBeep( HMI_TCP_TIMEOUT_BEEP );    

   hmi_SetLED( HMI_STARTUP_LED );
   if ( HMI_STARTUP_BEEP )
      hmi_Beep();

   if ( HMI_TOUCH_BEEP )
      hmi_TurnTouchBeep(1);
       
   if ( HMI_LCD_AUTO_OFF ) 
   {
      hmi_LCDIdleSetTimeout( HMI_LCD_AUTO_OFF * 1000 );
      hmi_LCDIdleSetBeep(HMI_LCD_OFF_BEEP, HMI_LCD_ON_BEEP);
   }

   _frame0();
}
