#include "hmiworks.h"
BYTE ladder_main(BYTE);
static BYTE r_out(BYTE);

int _CurrentFrame = 0;

char *g_FrameNames[] = 
{
  "Frame1",
};

const int g_FrameCount = (sizeof(g_FrameNames)/sizeof(char *));


HANDLE COM1_1;
HANDLE Dev_I_7017_1;


volatile unsigned long g_TimerTicksCount = 0;
void hmi_TimerTrigger()
{
  g_TimerTicksCount++;
  if (table_init_flag && (g_TimerTicksCount%(100/10)) == 0) AddQueueMessage(0);
  
  switch(_CurrentFrame) {
    case 1: {
    break;
    }
  }
}

void FreeCurrentFrame()
{
  switch (_CurrentFrame)
  {
	case 1: FreeWidget1(); break;
  }
}

void hmi_GotoFrame(int nFrame)
{
  WidgetMessageQueueProcessEx(WIDGET_MSG_PAINT);

  switch(nFrame)
  {
	case 1: _frame1(); break;
  }

  WidgetMessageQueueClear();
  WidgetPaint(WIDGET_ROOT);
}

int hmi_IndexOfFrame(const char *frame_name)
{
    int i;
    for (i=0; i<g_FrameCount; i++)
       if (strcmp(frame_name, g_FrameNames[i]) == 0) return i+1;
    return 0;
}


void hmi_GotoFrameByName(const char *frame_name)
{
    hmi_GotoFrame(hmi_IndexOfFrame(frame_name));
}

long default_timer_proc(tWidget *pWidget, unsigned long ulMessage,
                     unsigned long ulParam1, unsigned long ulParam2)

{
  ladder_main(1);
  passDataThruBindingOnChange();
  r_out(1);
  return 1;
}


BYTE polling_Dev_I_7017_1(BYTE en)
{
  if ( !VAR_VALUE(Dev_I_7017_1_ENABLE_DEVICE) ) return 0;
BEGIN_FUNCTION_BLOCK();

float v_ai[8];
int   iRtn;

uart_SetTimeout(Dev_I_7017_1, 200);

if ( VAR_VALUE(Dev_I_7017_1_ENABLE_AI) && VAR_VALUE(Dev_I_7017_1_R_ACTION)) 
{ 
  iRtn = dcon_ReadAIAll(Dev_I_7017_1, 1, v_ai);
  VAR_SET(Dev_I_7017_1_AI0, v_ai[0]);
  VAR_SET(Dev_I_7017_1_AI1, v_ai[1]);
  VAR_SET(Dev_I_7017_1_AI2, v_ai[2]);
  VAR_SET(Dev_I_7017_1_AI3, v_ai[3]);
  VAR_SET(Dev_I_7017_1_AI4, v_ai[4]);
  VAR_SET(Dev_I_7017_1_AI5, v_ai[5]);
  VAR_SET(Dev_I_7017_1_AI6, v_ai[6]);
  VAR_SET(Dev_I_7017_1_AI7, v_ai[7]);
  
  if ( ! iRtn ) 
    return HMI_ERROR;
}

END_FUNCTION_BLOCK();

  return 0;
}


static BYTE r_out(BYTE en)
{
  default_output(1);

  static int polling_module;
  switch(polling_module++%1) {
  case 0:
    VAR_SET(Dev_I_7017_1_ERROR, polling_Dev_I_7017_1(en)? 1:0);
    break;

  default: break;
  } //end switch

  default_input(1);

  return 0;
}

void _frame0()
{
  tContext sContext;
  COM1_1 = uart_Open("COM1,115200,N,8,1");
  Dev_I_7017_1 = COM1_1;
  
  RegisterNullWidgetMsgProc(default_timer_proc);
  
  GrContextInit(&sContext, HMI_DISPLAY_DRIVER_PTR);
  hmi_GotoFrame(1);
  GrFlush(&sContext);
}
