#define HMI_STARTUP_DELAY 100
#define HMI_WDT_ENABLE 0
#define HMI_WDT_TIMEOUT 4000
#define HMI_WDT_CLEAR 1000
#define HMI_STARTUP_BEEP 1
#define HMI_TOUCH_BEEP 1
#define HMI_BEEP_FREQ 800
#define HMI_BEEP_MS 25
#define HMI_LCD_BRIGHTNESS 180
#define HMI_STARTUP_LED 0
#define HMI_LCD_AUTO_OFF 0
#define HMI_LCD_ON_BEEP 1
#define HMI_LCD_OFF_BEEP 1
#define HMI_TCP_TIMEOUT_BEEP 0


#include "hmiworks.h"

#define TICKS_PER_SECOND 100
#define MS_PER_TICK      (1000 / TICKS_PER_SECOND)

void SysTickIntHandler()
{
   hmi_TimerTrigger();
}

int main(void)
{
   if ( HMI_STARTUP_DELAY )
      hmi_DelayUS( HMI_STARTUP_DELAY * 1000 );  

   if ( HMI_WDT_ENABLE )  // Enable Watchdog
   {
      hmi_WdtAutoClear( HMI_WDT_CLEAR );
      hmi_WdtEnable( HMI_WDT_TIMEOUT );
   }

   HMI_INIT(O_LANDSCAPE);
   hmi_BacklightSet( HMI_LCD_BRIGHTNESS );
   
    hmi_SetLED( HMI_STARTUP_LED );

    if ( HMI_STARTUP_BEEP )
        hmi_Beep();

    if ( HMI_TOUCH_BEEP )
        hmi_TurnTouchBeep(1);

    if ( HMI_LCD_AUTO_OFF )
    {
        hmi_LCDIdleSetTimeout( HMI_LCD_AUTO_OFF * 1000 );
        hmi_LCDIdleSetBeep(HMI_LCD_OFF_BEEP, HMI_LCD_ON_BEEP);
    }

    _frame0();
}
